<?php
defined('BASEPATH') or exit('No direct script access allowed');

class VenderCtrl extends MY_Controller
{

  public function __construct($config = 'rest')
  {
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Authorization, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
    header("Allow: GET, POST, OPTIONS, PUT, DELETE");
    header('content-type: application/json; charset=utf-8');
    $method = $_SERVER['REQUEST_METHOD'];
    if ($method == "OPTIONS") {
      die();
    }
    parent::__construct();

    // add library of Lioren 
    $this->Lioren = $this->ConfigModels->Value("Lioren");
    $this->load->library('LibLioren');
  }
  public function _remap($met, $parametros = array())
  {

    $method = $_SERVER['REQUEST_METHOD'];

    if ($met === "index") {

      switch ($method) {
        case 'GET':

          // var_dump(worpress(5));


          break;
        case 'POST':
          $this->Add();
          break;
        default:
          echo json_encode("Error");
          break;
      }
    }
  }

  private function DistribuirDescuento( $data,$val,$Contador=0,$Codigo,$Precio, $Exento,$Desc =0,$Can =0,$Fact=FALSE){
 
    if ($Desc <1){
     return  array($data,$Can,$Contador);
    }
   

    $DescAux = $Desc;
    $NewDes = 0;
    if($Fact === TRUE){
      $DescAux = (float)$DescAux / 1.19;
      $DescAux =  round(($Desc *100)/$Precio,2);
     
    }
    if( $Desc >$Precio  ){
      $DescAux = $Precio;
      $NewDes = (float) $Desc-(float)$Precio;
     
      if($Fact === TRUE){
        $DescAux =  99.99;
      }
    }

  
    $data['detalles'][$Contador] = [
      'codigo' => $val['Producto']."Des".$Can,
      'nombre' =>  $val['Nombre'] . ' ' . $val['Marca'] . ' ' . $val['Modelo'],
      'cantidad' =>  1,
      'precio' => $Precio,
      'exento' =>  $Exento,
      "descuento" =>  $DescAux,
      "tipodescuento" => 1
    ];
    $Contador++;
    $Can++;
    return  $this->DistribuirDescuento($data,$val,$Contador,$Codigo,$Precio, $Exento,$NewDes,$Can,$Fact);
  }
  private function ProcesarLioren($Datos)
  {
   
    $LIOREN = new LibLioren();
    $BoletaLoren = null;
    $Codigo = "Código";
    $data = [
      'emisor' =>
      [
        'tipodoc' => '39',
        'servicio' => 3,
      ],
      'detalles' => [],
      'expects' => 'all',
    ];
    $Exento =  $Datos["Select"]['Tipo']['value'] === 'Exento' ? true : false;
    $Contador = 0;
    foreach ($Datos["Articulos"] as $key => $val) {  // Recorremos todos los productos 1 por 1
    $desPor = 0;
    $desEff = 0;
    $Precio = (float)$val['Precio'];
    if((float)$val['Cantidad'] >= (float)$val['PorMayor'] AND (float)$val['PrecioM'] > 0 ){
      $Precio = (float)$val['PrecioM'];
    }
    if ($Datos["Select"]['Tipo']['value'] === 'Factura') {
      $Precio =   (float)$Precio / 1.19;

    }
      // ingresamo el detalle de la venta
      if ((float)$val['Descuento'] > 0) {
        $desPor = ((float)$val['Descuento'] / ((float)$val['Cantidad'])) / 1.19;
        $desPor = round(($desPor *100)/$Precio,2);
        $desEff =  ((float)$val['Descuento'] / ((float)$val['Cantidad']));
        $data['detalles'][$Contador] = [
          'codigo' => $val['Producto'],
          'nombre' =>  $val['Nombre'] . ' ' . $val['Marca'] . ' ' . $val['Modelo'],
          'cantidad' =>  (float)$val['Cantidad'],
          'precio' =>$Precio,
          'exento' =>  $Exento,
          "descuento" => $Datos["Select"]['Tipo']['value'] === 'Factura'? $desPor :  $desEff,
          "tipodescuento" => 1
        ];
          /*
          if( (float)$val['Cantidad'] ==1){
            $desPor = (float)$val['Descuento'] / 1.19;
            $desPor = round(($desPor *100)/$Precio,2);
            $data['detalles'][$Contador] = [
              'codigo' => $val['Producto'],
              'nombre' =>  $val['Nombre'] . ' ' . $val['Marca'] . ' ' . $val['Modelo'],
              'cantidad' =>  (float)$val['Cantidad'],
              'precio' =>$Precio,
              'exento' =>  $Exento,
              "descuento" => $Datos["Select"]['Tipo']['value'] === 'Factura'? $desPor : $val['Descuento'],
              "tipodescuento" => 1
            ];
          }else {
            $Fact = $Datos["Select"]['Tipo']['value'] === 'Factura' ?TRUE:FALSE;
           $Arr= $this->DistribuirDescuento(array(),$val,0,$Codigo,$Precio, $Exento,(float)$val['Descuento'],0,$Fact);
            for ($k=0;$k<count($Arr[0]['detalles']);$k++){
              $data['detalles'][$Contador] = $Arr[0]['detalles'][$k] ;
              $Contador++;
            }
            if( (float)$val['Cantidad']-$Arr[2]>0){
              $data['detalles'][$Contador] = [
                'codigo' => $val['Producto'],
                'nombre' =>  $val['Nombre'] . ' ' . $val['Marca'] . ' ' . $val['Modelo'],
                'cantidad' =>  (float)$val['Cantidad']-$Arr[2],
                'precio' => $Precio,
                'exento' =>  $Exento,
              ];
            }
            
          }
          */
       
      } else {

        $data['detalles'][$Contador] = [
          'codigo' => $val['Producto'],
          'nombre' =>  $val['Nombre'] . ' ' . $val['Marca'] . ' ' . $val['Modelo'],
          'cantidad' =>  (float)$val['Cantidad'],
          'precio' => $Precio,
          'exento' =>  $Exento,
        ];
      }
      $Contador++;
    }

    $Cliente = $Datos["Select"]['Cliente']['value'] === "" ? [] : $this->ClientModels->getClient($Datos["Select"]['Cliente']['value']);
   // $LIOREN->setServerToken("Chupalo");
    if ($Datos["Select"]['Tipo']['value'] === 'Factura') {
      $telefono = utf8_encode("Teléfono");
      $direccion = utf8_encode("Dirección");
     $Rut = $this->FormatoRut( $Cliente[0]->Rut);
      $data['receptor'] = ['rut' =>   $Rut, 'telefono' => $Cliente[0]->$telefono, 'direccion' => $Cliente[0]->$direccion, 'comuna' => $Cliente[0]->Comuna, 'ciudad' => $Cliente[0]->Ciudad, 'rs' => $Cliente[0]->RS, 'giro' => $Cliente[0]->giro, 'email' => $Cliente[0]->Correo];
      $data['emisor']['tipodoc'] = '33';
      $data['emisor']['fecha'] = date("Y-m-d");

      $BoletaLoren = json_decode($LIOREN->EmitirFactura($data), true);
    } else {
      $BoletaLoren = json_decode($LIOREN->EmitirBoleta($data), true);
    }

    if (isset($BoletaLoren["errors"])) {

      $this->VentaTempModels->Add(['1'=>json_encode($BoletaLoren["errors"])]);
      print_r($BoletaLoren);
      exit;
    }

    if (isset($BoletaLoren["pdf"])) {
      $Dir = Raiz();
      if (Existe($Dir . '/Boletas/') === false) {
        CrearCarpeta($Dir . '/Boletas/');
      }

      if (count($Cliente) > 0) {
        if (isset($Cliente[0]->Correo)) {
          $binary = base64_decode($BoletaLoren["pdf"]);
          $file = fopen($Dir . '/Boletas/' . $Cliente[0]->Nombre . "Boleta.pdf", "wb");
          fwrite($file, $binary);
          fclose($file);
          if ($Cliente[0]->Correo != "") {
            $htmlContent = '<h1>Su Boleta o Factura </h1>';
            if (Existe($Dir . '/Boletas/' . $Cliente[0]->Nombre . "Boleta.pdf") === true) {
              EmailHtml($Cliente[0]->Correo, "BOLETA", $htmlContent, $Dir . '/Boletas/' . $Cliente[0]->Nombre . "Boleta.pdf");
              unlink($Dir . '/Boletas/' . $Cliente[0]->Nombre . "Boleta.pdf");
            }
          }
        }
      }
    }
    if (isset($BoletaLoren["xml"])) {
      $binary = base64_decode($BoletaLoren["xml"]);
      $file = fopen("Rod" . "Documento.xml", "wb");
      fwrite($file, $binary);
      fclose($file);
    }
    return $BoletaLoren;
  }

  private function ValidarCdProducto($CD)
  {
    $Res =  $this->db->get_where("producto", array("CodigoP" => $CD))->result();
    if (count($Res) === 0) {
      return $CD;
    }
    if ($Res[0]->Status === "Auxiliar") {
      return $Res[0]->CodigoAux;
    }
    return $CD;
  }
  private function FormatoRut($Rut){
    $newRut = str_replace(".", "", $Rut);
    $newRut = str_replace("-", "", $newRut);
    $Ultimo = substr($newRut, -1);
    $rest = substr($newRut, 0, -1);
   
    return $rest.$Ultimo;
   }
  private function Add()
  {
    $LIOREN2 = new LibLioren();
    $Datos = count($_POST) === 0 ? $this->input->raw_input_stream :  $this->input->post();
    if (is_string($Datos) === true) {
      $Datos =  json_decode($Datos, true);
    }

    $Codigo = "Código";
    $Producto = "";

    if ($this->Lioren === true) {
      $BoletaLioren = $this->ProcesarLioren($Datos);
    }
   if (count($Datos["Articulos"]) ===0){
    header('Content-type: application/json; charset=utf-8');
    echo json_encode(array("Error"=>"Debe Enviar los Articulos"));
    return;
   }
    // Ingresamos la venta en la db

    /*
  $num= 1;
  $obj = new stdClass();
  $obj->$num = 'Total';
  $num= 2;
  $obj->$num = 'iva';
  $num= 3;
  $obj->$num = 'Cliente';
  $num= 4;
  $obj->$num = 'Fecha';
  $num= 5;
  $obj->$num = 'Usuario';
  $num= 7;
  $obj->$num = 'mediopago';
  $num= 8;
  $obj->$num = 'Status';
  $num= 9;
  $obj->$num = 'efectivo';
  $num= 10;
  $obj->$num = 'debito';
  $num= 11;
  $obj->$num = 'Credito';
  $num= 12;
  $obj->$num = 'Descuento';
  $num= 12;
  $obj->$num = 'TipoBoleta';
  $num= 14;
  $obj->$num= 'Folio';
  $num= 15;
  $obj->$num= 'idLioren';
  $json = json_encode($obj);
*/
$Total =  floatval($Datos["Totales"]['cantidades']['efectivo']) + floatval($Datos["Totales"]['cantidades']['debito']) + floatval($Datos["Totales"]['cantidades']['Tcredito']);
    $num = 1;
    $obj = new stdClass();
    $obj->$num = $Datos["Totales"]['Subtotal'];
    $num = 2;
    $obj->$num = $Datos["Totales"]['Iva'];
    $num = 16;
    $obj->$num = $Datos["Totales"]['ILA'];
    if ($Datos["Select"]['Cliente']['value'] != "") {
      $num = 3;
      $obj->$num = $Datos["Select"]['Cliente']['value'];
    }

    $num = 4;
    $Object = new DateTime();
    $DateAndTime = $Object->format("Y-m-d h:i:s");
    $obj->$num = $DateAndTime;
    $num = 5;
    $Token = obtnerToken();
    $Autho = "";
   if($Token != FALSE){
    $Autho =str_replace('Bearer ','', $Token);
   }
   if( $Autho !=""){
    $Autho =str_replace('Bearer ','', $Autho);
    $Token = ValidarToken($Autho);
  }
    if(isset($this->session)){
      $ID =  $Token== FALSE ? $this->session->userdata("User") :  $Token ;
}else{
      $ID =   $Token== FALSE ? null :  $Token ;
}
    $obj->$num = $ID;
    $num = 7;
    $obj->$num = $Datos["Select"]['Medio']['value'];
    $num = 8;
    $obj->$num = 'Procesado';
    if(isset($Datos["VentaCredito"])){
      if($Datos["VentaCredito"] == TRUE && $Total <  floatval($Datos["Totales"]['Subtotal']) ){
        $obj->$num = 'En Proceso';
      }
    }
    
    if (isset($Datos["Totales"]['cantidades'])) {
      $num = 9;
      $obj->$num = $Datos["Totales"]['cantidades']['efectivo'];
      $num = 10;
      $obj->$num = $Datos["Totales"]['cantidades']['debito'];
      $num = 11;
      $obj->$num = $Datos["Totales"]['cantidades']['Tcredito'];
    }
   
    $num = 12;
    if (isset($Datos["Totales"]['Descuento'])) {
      $obj->$num = $Datos["Totales"]['Descuento'];
    }
    $num = 13;
    $obj->$num = $Datos["Select"]['Tipo']['value'];
    if ($this->Lioren === true) {
      $num = 14;
      $obj->$num = $BoletaLioren["folio"];
      $num = 15;
      $obj->$num = $BoletaLioren["id"];
    }



    $json = json_encode($obj);

    $IDVNTA = $this->VentasModels->Add($obj);
    // fin de agregar ventas 
    // ahora vamos a operar en los productos 
    foreach ($Datos["Articulos"] as $key => $val) {  // Recorremos todos los productos 1 por 1

      // Descontamos de almacen los productos
      $Producto = '{"Status":1,"Observacion":"Venta","Cantidad":"' . $val['Cantidad'] . '","CodigoMo":"' . $val[$Codigo] . '","CodigoAux": "' . $val['CodigoAux'] . '" }';
      $Producto = json_decode($Producto, true);
      $Producto = $this->WarehouseModels->Edit($Producto);

      // ingresamo el detalle de la venta

      $Precio = (float)$val['Precio'];
      if((float)$val['Cantidad'] >= (float)$val['PorMayor'] AND (float)$val['PrecioM'] > 0 ){
        $Precio = (float)$val['PrecioM'];
      }

      if (!isset($Producto["Detalle"])) {
        $Detalle = '{"1":"' . $IDVNTA . '","2":"' . $val['Cantidad'] . '","3":"' . $Precio  . '","4":"' . $val['Total'] . '","6": "' . $val[$Codigo] . '","7": "' . $val['Descuento'] . '" }';
      } else {
        $Detalle = '{"1":"' . $IDVNTA . '","2":"' . $val['Cantidad'] . '","3":"' . $Precio  . '","4":"' . $val['Total'] .'","10": "' . $val['ILA']. '","5": "' . $val['IVA']. '","6": "' . $val[$Codigo] . '","9": "' . $Producto["Detalle"] . '","7": "' . $val['Descuento'] . '" }';
      }



      $Detalle = json_decode($Detalle, true);
      $IDDETALLE = $this->DetalleVentasModels->Add($Detalle);

      $WOOR= $this->ConfigModels->Value("WOOR");
      $MiTienda= $this->ConfigModels->Value("MiTienda");
      worpress( $WOOR,$this->ValidarCdProducto($val['Producto']),$MiTienda);
    }
    // buscamos los datos del cliente y de la tienda 
    $Token = obtnerToken();
    $Autho = "";
   if($Token != FALSE){
    $Autho =str_replace('Bearer ','', $Token);
   }
   if( $Autho !=""){
    $Autho =str_replace('Bearer ','', $Autho);
    $Token = ValidarToken($Autho);
  }
    if(isset($this->session)){
      $IDuser =  $Token == FALSE ? $this->session->userdata("User") :  $Token;
}else{
  $IDuser =  $Token == FALSE ?null :  $Token;
}
    

    $User = $this->UserModels->getUser($IDuser);
    $Tienda = $this->StoreModels->getStore($User[0]->Tienda);
    $Rut = "666666666";
    if ($Datos["Select"]['Cliente']['value'] != "") {
      $Cliente = $this->ClientModels->getClient($Datos["Select"]['Cliente']['value']);
      if($Datos["Select"]['Tipo']['value'] === 'Factura'){
        $Rut = $this->FormatoRut( $Cliente[0]->Rut);
      }
     
    } else {
      $Cliente = null;
    }
  // si la venta es a Credito creamos el registro
  if(isset($Datos["VentaCredito"])){
    if($Datos["VentaCredito"] == TRUE){
      $objCredito = new stdClass();
     
      $objCredito->Venta = $IDVNTA;
      $objCredito->Observacion = $Datos["TextBox"]["Obs"]["value"];
     
    
      $objCredito->Abono = $Total;
      $objCredito->Tienda = $User[0]->Tienda;
     
        $this->CreditosModels->Add($objCredito);
      
    }
  }
    $Resp = new stdClass();
    $Resp->Venta =  $IDVNTA;
    $Resp->Client =  $Cliente;
    $Resp->Tienda =  $Tienda;
    if ($this->Lioren === true) {
      $Resp->rut0 =  $LIOREN2->GetRut();
      $Resp->rut1 =  $Rut;
      $Resp->codigosii =  $BoletaLioren["tipodoc"];
      $Resp->fecha =  $BoletaLioren["fecha"];
      $Resp->neto =  $BoletaLioren["montoneto"];
      $Resp->exento =  $BoletaLioren["montoexento"];
      $Resp->printer =  "674";
      $Resp->id =  $BoletaLioren["id"];
     // $Resp->pdf =  $BoletaLioren["pdf"];
      $Resp->Lioren =  "Si";
    }
    if (isset($Datos["VentaTempID"])) {
      if (intval($Datos["VentaTempID"]) > 0) {
        $this->VentaTempModels->Delete(intval($Datos["VentaTempID"]));
      }
    }
    header('Content-type: application/json; charset=utf-8');
    echo json_encode($Resp);
  }

  protected function middleware()
  {
    return ['Sesion'];
  }
}
