<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ReportDetalleProveedorModels extends CI_Model
{

    private $Tabla = "detallemov";                 
    private $Delimitador= "|";
    private $Separador = "^";
    private $CamposTablas = ["movimientop.CodigoM","detallemov.CodigoProve","producto.CodigoP","CONCAT(producto.Nombre, ' ' , producto.Marca, ' ', producto.Modelo, ' ', producto.Descripcion)","detallemov.Cantidad","detallemov.Fecha","detallemov.Costo","CONCAT(proveedor.Nombres, ' ',proveedor.Apellidos )","proveedor.Correo", "proveedor.Telefono", "clasificacion.Nombre","movimientop.CodigoT","movimientop.Existencia"];
    private function InitJoin(){
        $this->db->join("proveedor"," proveedor.CodigoProve = detallemov.CodigoProve","INNER",false);
        $this->db->join("movimientop"," movimientop.CodigoM = detallemov.CodigoMo","INNER",false);
        $this->db->join("producto","movimientop.CodigoP = producto.CodigoP","LEFT",false);
        $this->db->join("clasificacion","clasificacion.ID = producto.Clasificacion","LEFT",false);
        $this->db->where('proveedor.Status',$this->db->escape("Activo"),false); 
        $this->db->where('producto.Status',$this->db->escape("Activo"),false); 
          $this->db->where('detallemov.CodigoD','(SELECT Aux.CodigoD FROM detallemov Aux  WHERE  Aux.CodigoMo = detallemov.CodigoMo AND detallemov.CodigoProve = Aux.CodigoProve   ORDER BY Fecha ASC   LIMIT 1 )',false);      
       }
    private function ValidarCdProducto($CD){
        $Res=  $this->db->get_where("producto",array("CodigoP"=>$CD))->result();
        if (count($Res) ===0){
            return $CD;
        }
        if ($Res[0]->Status === "Auxiliar"){
            return $Res[0]->CodigoAux;
        }
        return $CD;

    }
 



    private function Filtros($Filtros){
        $Filtros= str_replace('ø','/',$Filtros);
        $arr1 = explode($this->Delimitador,$Filtros);
        $array_num = count($arr1);
        $arr1 = array_values($arr1);
        for ($i = 0; $i < $array_num; ++$i){
           
            $posicion_coincidencia = strpos($arr1[$i], $this->Separador);
            if(  $posicion_coincidencia != FALSE ){
              $Array2 = explode($this->Separador,$arr1[$i]);
              $Array2[0]= $this->columna($Array2[0]);
              if($Array2[0]==="producto.CodigoP")
              {
                $Array2[1]= $this->db->escape($this->ValidarCdProducto($Array2[1]));
              }else{
                
               
                $Array2[1]= $this->db->escape($Array2[1]); 
              }
              $arr1[$i] =  $Array2;
              $posicion_coincidencia = strpos( $Array2[1], ',');

              if($posicion_coincidencia === false ){
               
              }else{
             
                 
                $Fechas =  explode(',',$Array2[1]);

                if(count($Fechas) ===2){
                    $this->db->where($Array2[0]." BETWEEN ".$Fechas[0]."' AND '".$Fechas[1]."", NULL, FALSE );
                    unset($arr1[$i]);
                }
                
              }
              

             
            }else {
                $arr1[$i]= array("Todo", $arr1[$i]);
            }
        }
     
        return  $arr1;
    }

   
    private  function columna($id = null,$Mascara = false){
        $fields = $this->CamposTablas;
        if($id === null){
          
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                $fields[$i] =  $fields[$i]. " AS ". $this->Mascara($fields[$i]);
            }
            return $fields;

        }

        if(is_numeric($id)===false){
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                if($id === $fields[$i] ||  $this->Mascara($fields[$i]) === $id ){
                    if($Mascara=== false){
                        return $fields[$i];
                    }else{
                        return $fields[$i]. " AS ". $this->Mascara($fields[$i]);
                    }
                  
                }
              
            }
            return $fields[0];
        }else{

       

        if($Mascara === false){
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)];
              }else{
                return $fields[0];
              }
        }else{
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)]. " AS ". $this->Mascara($fields[intval($id)]);
              }else{
                return $fields[0]. " AS ". $this->Mascara($fields[0]);
              }        
        }
    }
       
    }
    private function Columnas($col = null,$Mascara = false){
          if($col=== null){
           $Arra =  $this->columna(null);
           return $Arra;
          }

        $Colu = substr($col, 1);
        $posicion_coincidencia = strpos($Colu, $this->Delimitador);
        if(  $posicion_coincidencia === FALSE ){
            $arr1 = str_split($Colu);
        }else{
            $arr1 = explode($this->Delimitador,$Colu);
        }
     
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
            $arr1[$i] =  $this->columna($arr1[$i],$Mascara);
        }
        return $arr1;
    }
    public function getReportDetalleProveedor($id=NULL)
    {
       
       if ($id === NULL){
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
     
       }else{
          
           $Columna = $this->columna(0);
           $this->db->distinct()->select($this->Columnas(),false);
           $this->InitJoin();
           $this->db->where('proveedor'.'.CodigoProve',$this->db->escape("$id"),false);
           return  $this->db->get($this->Tabla)->result();

       }
       
    }
    public function getReportDetalleProveedorLimite($Canti,$Desde){
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportDetalleProveedorLimiteOrden($Canti,$Desde,$Columna,$Orden){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
     
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportDetalleProveedorLimiteOrdenColumnas($Canti,$Desde,$Columna,$Orden,$Columnas){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportDetalleProveedorIdColum($id,$Columnas){
       
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $Columna = $this->columna(0);
        $this->InitJoin();
        $this->db->where($Columna,$this->db->escape("$id"),false);
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReportDetalleProveedorLimiteColum($Canti,$Desde,$Columnas){
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportDetalleProveedorFiltro($Filtros){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.'proveedor'.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where('proveedor'.'.Status =',"'Activo')",false ); 
        }
      
        $this->db->distinct()->select($this->Columnas(),false);
     return  $this->db->get($this->Tabla)->result();
      
    }
    private function total(){
        $this->db->distinct()->select("count(*) As Total",false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReportDetalleProveedorFiltroLimite($Filtros,$Canti,$Desde){
      
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.'proveedor'.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where('proveedor'.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas(),false);
     return   $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportDetalleProveedorFiltroLimiteOrden($Filtros,$Canti,$Desde,$Columna,$Orden){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.'proveedor'.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where('proveedor'.'.Status =',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->distinct()->select($this->Columnas(),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportDetalleProveedorFiltroLimiteOrdenColumnas($Filtros,$Canti,$Desde,$Columna,$Orden,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.'proveedor'.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where('proveedor'.'.Status =',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
     $this->db->distinct()->select($this->Columnas($Columnas,true),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportDetalleProveedorFiltroColumnas($Filtros,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.'proveedor'.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where('proveedor'.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla)->result();
      
    }

    public function getReportDetalleProveedorFiltroLimitesColumnas($Filtros,$Canti,$Desde,$Columnas){
      
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
    
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.'proveedor'.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where('proveedor'.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
   
// desde aqui comianza la configuracion

    private function Mascara($Clave= null){
        
        
$ArrayReportDetalleProveedor["movimientop.CodigoM"]= utf8_encode("Código");
$ArrayReportDetalleProveedor["detallemov.CodigoProve"]= utf8_encode("CodProveedor");
$ArrayReportDetalleProveedor["detallemov.Cantidad"]= "Cantidad";
$ArrayReportDetalleProveedor["detallemov.Fecha"]= "Fecha";
$ArrayReportDetalleProveedor["detallemov.Costo"]= "Costo";
$ArrayReportDetalleProveedor["CONCAT(proveedor.Nombres, ' ',proveedor.Apellidos )"]= "Proveedor";
$ArrayReportDetalleProveedor["proveedor.Correo"]= "Email";
$ArrayReportDetalleProveedor["proveedor.Telefono"]= utf8_encode('Teléfono');
$ArrayReportDetalleProveedor["producto.CodigoP"]= "Producto";
$ArrayReportDetalleProveedor["CONCAT(producto.Nombre, ' ' , producto.Marca, ' ', producto.Modelo, ' ', producto.Descripcion)"]= "Nombre";
$ArrayReportDetalleProveedor["clasificacion.Nombre"]= utf8_encode('Área');
$ArrayReportDetalleProveedor["movimientop.CodigoT"]= utf8_encode("CodigoT");
$ArrayReportDetalleProveedor["movimientop.Existencia"] = "stock";
if($Clave === null){
    $array = array();
    foreach($ArrayReportDetalleProveedor as $key => $val) {
        $array[$val]= array_search(array_search($val,$ArrayReportDetalleProveedor),$this->CamposTablas)
       ;
    }
    
   
    return $array;
}       


if (isset($ArrayReportDetalleProveedor[$Clave])){
return $ArrayReportDetalleProveedor[$Clave];
}else{
return $Clave;
}
}

    private function verificarExistencia($dato,$Array)
    {
        $array_num = count($Array);
        for ($id = 0; $id < $array_num; ++$id){
            if($Array[$id]["nombre"] == $dato){
              return $id;
            }
        }
        return false;
    }






   Public function MetaData($Mascara = true){

    $meta3['Producto'] = [
        "name"=> 'Producto',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Product',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s02',
        "necessary"=> true, 
        "modified"=> false, 
        "type"=>'text', 
    ];
    $meta3['Área'] = [
        "name"=> 'Área',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Classification',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Clasificación',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Venta'] = [
        "name"=> 'Venta',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Ventas',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Codigo',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Tienda'] = [
        "name"=> 'Tienda',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Store',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Tienda',
        "necessary"=> true, 
        "modified"=> false, 
        "type"=>'text',  
    ];
    $meta3['Proveedor'] = [
        "name"=> 'Proveedor',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Provider',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Nombre',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['RutU'] = [
        "name"=> 'RutU',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'User',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Rut',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['RutC'] = [
        "name"=> 'RutC',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Client',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Rut',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Fecha'] = [
        "name"=> 'Fecha',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'date', 
    ];

    

/*
    $meta3['Region'] = [
        "name"=> 'Región',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>"",
        "1"=>"Región de Arica y Parinacota",
        "2"=>"Región de Tarapacá",
        "3"=>"Región de Antofagasta",
        "4"=>"Región de Atacama",
        "5"=>"Región de Coquimbo", 
        "6"=>"Región de Valparaíso",
        "7"=>"Región del Libertador General Bernardo O'Higgins",
        "8"=>"Región del Maule",
        "9"=>"Región del Biobío",
        "10"=>"Región de La Araucanía",
        "11"=>"Región de Los Ríos",
        "12"=>"Región de Los Lagos",
        "13"=>"Región Aysén del General Carlos Ibáñez del Campo",
        "14"=>"Región de Magallanes y de la Antártica Chilena",
        "27"=>"Región de Ñuble",
        ],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Comuna'] = [
        "name"=> 'Comuna',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>""],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Ciudad'] = [
        "name"=> 'Ciudad',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>""],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
*/
 
   $T =  $this->total();
    $obj = new stdClass();
    $obj->Total  = $T[0]->Total;
    $obj->Campos= $this->Mascara();
    $obj->Select= $meta3;
return $obj;

} 

}
